#include <GL/glut.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <unistd.h>
int const scrwdth=512, scrhght=512;
int texture[256]={
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
};
int toggle=0;
FILE *fp;


void load(){
	int skip=0;
	char pathname[256], buff;
	getcwd(pathname,256);
	strcat(pathname,"\\base.txt");
	fp = fopen(pathname, "r");
	for(int i=0;i<256+16;i++){
		buff=fgetc(fp);
		if(buff!='\n'){
			texture[i-skip]=buff-48;
		}else{
			skip++;
		}
	}
	fclose(fp);
}

void init(){//initializes
	glClearColor(1,1,1,0);
	gluOrtho2D(0,scrwdth,scrhght,0);
}

void drawselect(){
	glColor3f(0.3,0.3,0.5);
	glRasterPos2f(15,15);
	glutBitmapCharacter(GLUT_BITMAP_8_BY_13,toggle+'0');
	
}

void drawlines(){
	for(int i=0;i<16;i++){
		glColor3f(0.5,0.5,0.5);
		glLineWidth(1);
		glBegin(GL_LINES);
		glVertex2i(i*32,0);
		glVertex2i(i*32,512);
		glEnd();
	}
		for(int i=0;i<16;i++){
		glColor3f(0,0,0);
		glLineWidth(1);
		glBegin(GL_LINES);
		glVertex2i(0,i*32);
		glVertex2i(512,i*32);
		glEnd();
	}
}

void drawsquares(){
	for(int i=0;i<16;i++){
		for(int j=0;j<16;j++){
			switch(texture[i*16+j]){
				case 0:
				glColor3f(0,0,0);
				glBegin(GL_QUADS);
				glVertex2i(i*32,j*32);
				glVertex2i(i*32+32,j*32);
				glVertex2i(i*32+32,j*32+32);
				glVertex2i(i*32,j*32+32);
				glEnd();
				glColor3f(1,1,1);
				glRasterPos2f((i)*32,(j)*32+16);
				glutBitmapCharacter(GLUT_BITMAP_8_BY_13,texture[i*16+j]+'0');
				break;
				case 1:
				glColor3f(1,0,0);
				glBegin(GL_QUADS);
				glVertex2i(i*32,j*32);
				glVertex2i(i*32+32,j*32);
				glVertex2i(i*32+32,j*32+32);
				glVertex2i(i*32,j*32+32);
				glEnd();
				glColor3f(1,1,1);
				glRasterPos2f((i)*32,(j)*32+16);
				glutBitmapCharacter(GLUT_BITMAP_8_BY_13,texture[i*16+j]+'0');
				break;
				case 2:
				glColor3f(0,1,0);
				glBegin(GL_QUADS);
				glVertex2i(i*32,j*32);
				glVertex2i(i*32+32,j*32);
				glVertex2i(i*32+32,j*32+32);
				glVertex2i(i*32,j*32+32);
				glEnd();
				glColor3f(1,1,1);
				glRasterPos2f((i)*32,(j)*32+16);
				glutBitmapCharacter(GLUT_BITMAP_8_BY_13,texture[i*16+j]+'0');
				break;
				case 3:
				glColor3f(0,0,1);
				glBegin(GL_QUADS);
				glVertex2i(i*32,j*32);
				glVertex2i(i*32+32,j*32);
				glVertex2i(i*32+32,j*32+32);
				glVertex2i(i*32,j*32+32);
				glEnd();
				glColor3f(1,1,1);
				glRasterPos2f((i)*32,(j)*32+16);
				glutBitmapCharacter(GLUT_BITMAP_8_BY_13,texture[i*16+j]+'0');
				break;
				case 4:
				glColor3f(0.5,0.5,0.5);
				glBegin(GL_QUADS);
				glVertex2i(i*32,j*32);
				glVertex2i(i*32+32,j*32);
				glVertex2i(i*32+32,j*32+32);
				glVertex2i(i*32,j*32+32);
				glEnd();
				glColor3f(1,1,1);
				glRasterPos2f((i)*32,(j)*32+16);
				glutBitmapCharacter(GLUT_BITMAP_8_BY_13,texture[i*16+j]+'0');
				break;
			}
		}
	}
}

void save(){
	char pathname[256];
	getcwd(pathname,256);
	strcat(pathname,"\\textures\\newtexture.txt");
	fp = fopen(pathname, "w");
	for(int i=0;i<256;i++){
		if(!(i%16)){
			fputc('\n',fp);
		}
		fputc(texture[i]+'0',fp);
	}
	fclose(fp);
}

void mouse(int mousex, int mousey){
	texture[mousey/32+mousex/32*16]=toggle;
	glutPostRedisplay();
}

void press(unsigned char key, int x, int y){
	if(key==' '){save();}
	if(key=='+'){toggle++;toggle=toggle%6;}
	if(key=='-'){toggle--;toggle=(toggle+1)?toggle:5;}
	glutPostRedisplay();
}

void display(){// display function
	glClear(GL_COLOR_BUFFER_BIT);
	drawsquares();
	drawlines();
	drawselect();
	glutSetCursor(GLUT_CURSOR_CROSSHAIR);
	glutSwapBuffers();
}

void click(int button, int state, int mousex, int mousey){
	if((button==GLUT_LEFT_BUTTON)&&(state==GLUT_DOWN)){
		texture[mousey/32+mousex/32*16]=toggle;
		save();
	}
	glutPostRedisplay();
}

int main(int argc, char** argv){ 
	load();
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGBA);
	glutInitWindowSize(scrwdth,scrhght);
	glutCreateWindow("ebic");
	glutMotionFunc(mouse);
	glutMouseFunc(click);
	init();
	glutKeyboardFunc(press);
	glutDisplayFunc(display);
	glutMainLoop();
}